<?php
// Include this in admin pages to wrap content in a styled layout
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title><?= htmlspecialchars($page_title ?? 'Admin Dashboard') ?> - <?= SITE_NAME ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet" />
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        #sidebar {
            background-color: #0d6efd;
            min-height: 100vh;
            color: white;
            position: fixed;
            width: 220px;
        }
        #sidebar .nav-link {
            color: white;
        }
        #sidebar .nav-link:hover {
            background-color: #0b5ed7;
            color: white;
        }
        #content {
            margin-left: 220px;
            padding: 20px;
            flex: 1 0 auto;
            background: #f8f9fa;
        }
        .navbar-brand {
            font-weight: bold;
            color: white !important;
        }
        .notification-badge {
            position: absolute;
            top: 0;
            right: -6px;
            font-size: 0.75em;
            background: red;
            color: white;
            padding: 2px 6px;
            border-radius: 50%;
        }
    </style>
</head>
<body>
    <div class="d-flex">
        <nav id="sidebar" class="d-flex flex-column p-3">
            <a href="dashboard.php" class="navbar-brand mb-4"><?= SITE_NAME ?></a>
            <ul class="nav nav-pills flex-column mb-auto">
                <li class="nav-item">
                    <a href="dashboard.php" class="nav-link"><i class="fa fa-home me-2"></i> Dashboard</a>
                </li>
                <li>
                    <a href="manage_rooms.php" class="nav-link"><i class="fa fa-door-open me-2"></i> Manage Rooms</a>
                </li>
                <li>
                    <a href="manage_bookings.php" class="nav-link"><i class="fa fa-calendar-check me-2"></i> Manage Bookings</a>
                </li>
                <li>
                    <a href="logout.php" class="nav-link text-danger"><i class="fa fa-sign-out-alt me-2"></i> Logout</a>
                </li>
            </ul>
        </nav>

        <div id="content" class="flex-grow-1">
            <nav class="navbar navbar-expand navbar-dark bg-primary mb-4 rounded">
                <div class="container-fluid d-flex justify-content-between align-items-center">
                    <span class="navbar-text text-white">
                        Welcome, <?= htmlspecialchars($_SESSION['username'] ?? 'User') ?>
                    </span>

                    <?php
                    // Fetch unread notification count initially
                    $countStmt = $pdo->query("SELECT COUNT(*) FROM admin_notifications WHERE is_read = FALSE");
                    $unreadCount = $countStmt->fetchColumn();
                    ?>
                    <ul class="navbar-nav ms-auto">
                        <li class="nav-item dropdown">
                            <a id="notifDropdown" class="nav-link dropdown-toggle position-relative" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false" style="color:white; font-size: 1.25em;">
                                <i class="fa fa-bell"></i>
                                <?php if ($unreadCount > 0): ?>
                                    <span class="notification-badge count"><?= $unreadCount ?></span>
                                <?php endif; ?>
                            </a>
                            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="notifDropdown" style="min-width: 300px;">
                                <li><a class="dropdown-item" href="#">Loading notifications...</a></li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </nav>

            <main>
                <?= $content ?? '' ?>
            </main>

            <footer class="mt-auto py-3 bg-white text-center text-muted border-top">
                &copy; <?= date('Y') ?> <?= SITE_NAME ?>. All rights reserved.
            </footer>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
    $(document).ready(function() {
        function load_unseen_notifications(view = '') {
            $.ajax({
                url: 'fetch_notifications.php',
                method: 'POST',
                data: { view: view },
                dataType: 'json',
                success: function(data) {
                    $('.dropdown-menu').html(data.notification);
                    if(data.unseen_count > 0){
                        $('.count').text(data.unseen_count).show();
                    } else {
                        $('.count').text('').hide();
                    }
                }
            });
        }

        load_unseen_notifications();

        $('#notifDropdown').on('click', function() {
            $('.count').text('').hide();
            load_unseen_notifications('yes');
        });

        setInterval(function() {
            load_unseen_notifications();
        }, 5000); // Refresh every 5 seconds
    });
    </script>
</body>
</html>
