<?php

class Room
{
    private $pdo;

    public function __construct($pdo)
    {
        $this->pdo = $pdo;
    }

    public function getAllRooms()
    {
        $stmt = $this->pdo->query("SELECT * FROM rooms");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getRoomById($id)
    {
        $stmt = $this->pdo->prepare("SELECT * FROM rooms WHERE id = :id");
        $stmt->execute(['id' => $id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    // New method to get featured rooms, limiting results by default to 6
    public function getFeaturedRooms($limit = 6)
    {
        $stmt = $this->pdo->prepare("SELECT * FROM rooms WHERE featured = 1 ORDER BY id DESC LIMIT :limit");
        $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    // Count total rooms
    public function totalRooms()
    {
        return $this->pdo->query("SELECT COUNT(*) FROM rooms")->fetchColumn();
    }

    // Count total bookings
    public function totalBookings()
    {
        return $this->pdo->query("SELECT COUNT(*) FROM bookings")->fetchColumn();
    }

    // Count distinct users (clients) who have bookings
    public function totalClients()
    {
        return $this->pdo->query("SELECT COUNT(DISTINCT user_id) FROM bookings")->fetchColumn();
    }
}
