<?php

class Booking
{
    private $pdo;

    public function __construct($pdo)
    {
        $this->pdo = $pdo;
    }

    public function createBooking($data)
    {
        $stmt = $this->pdo->prepare("INSERT INTO bookings (room_id, guest_name, guest_email, check_in, check_out, status) VALUES (:room_id, :guest_name, :guest_email, :check_in, :check_out, 'pending')");
        return $stmt->execute([
            'room_id' => $data['room_id'],
            'guest_name' => $data['guest_name'],
            'guest_email' => $data['guest_email'],
            'check_in' => $data['check_in'],
            'check_out' => $data['check_out'],
        ]);
    }

    public function getBookingsByRoom($room_id)
    {
        $stmt = $this->pdo->prepare("SELECT * FROM bookings WHERE room_id = :room_id AND status != 'cancelled'");
        $stmt->execute(['room_id' => $room_id]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
