<?php

// Error reporting for development - comment out for production or set to 0
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Set custom error handler
set_error_handler('customErrorHandler');
set_exception_handler('customExceptionHandler');

// Error handler function
function customErrorHandler($errno, $errstr, $errfile, $errline)
{
    $message = "Error [$errno] in $errfile on line $errline: $errstr";
    logError($message);

    if (ini_get('display_errors')) {
        echo "<b>Error:</b> $message<br>";
    }
    return true; // prevent PHP internal handler
}

// Exception handler function
function customExceptionHandler($exception)
{
    $message = "Uncaught exception: " . $exception->getMessage() . " in " . $exception->getFile() . " on line " . $exception->getLine();
    logError($message);

    if (ini_get('display_errors')) {
        echo "<b>Exception:</b> " . htmlspecialchars($message);
    } else {
        echo "An error occurred. Please try again later.";
    }
    exit();
}

// Function to log errors to file
function logError($message)
{
    $logFile = __DIR__ . '/../../storage/logs/error.log';
    $date = date('Y-m-d H:i:s');
    $logEntry = "[$date] $message" . PHP_EOL;
    file_put_contents($logFile, $logEntry, FILE_APPEND);
}
