<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Your auth logic here

function requireLogin()
{
    if (!isset($_SESSION['user_id'])) {
        header('Location: ../public/login.php');
        exit();
    }
}

function requireAdmin()
{
    requireLogin();
    if ($_SESSION['role'] !== 'admin') {
        http_response_code(403);
        echo "Access denied. Admins only.";
        exit();
    }
}

function requireStaff()
{
    requireLogin();
    if (!in_array($_SESSION['role'], ['staff', 'admin'])) {
        http_response_code(403);
        echo "Access denied.";
        exit();
    }
}
