<?php
// Example PHP page: virtual_tour.php
// Assumes you have a 360 panorama image at /uploads/panoramas/room1.jpg

$panoramaImage = "uploads/panoramas/room1.jpg";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Room Virtual Tour</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/pannellum@2.5.6/build/pannellum.css" />
    <style>
        #panorama {
            width: 100%;
            max-width: 900px;
            height: 500px;
            margin: auto;
            border-radius: 1rem;
        }
    </style>
</head>
<body>
    <h2 style="text-align:center;">360° Virtual Tour - Room View</h2>

    <div id="panorama"></div>

    <script src="https://cdn.jsdelivr.net/npm/pannellum@2.5.6/build/pannellum.js"></script>
    <script>
        pannellum.viewer('panorama', {
            type: 'equirectangular',
            panorama: '<?= htmlspecialchars($panoramaImage) ?>',
            autoLoad: true,
            compass: false,
            northOffset: 0,
            showControls: true,
            hotSpotDebug: false
        });
    </script>
</body>
</html>
