<?php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'customer') {
    header('Location: login.php');
    exit;
}

require_once "../config/config.php";

$userId = $_SESSION['user_id'];

// Fetch user details
$stmt = $pdo->prepare("SELECT fullname, email, username FROM users WHERE id = ?");
$stmt->execute([$userId]);
$user = $stmt->fetch();

ob_start();
?>

<h2>Your Profile</h2>
<p><strong>Full Name:</strong> <?= htmlspecialchars($user['fullname']) ?></p>
<p><strong>Email:</strong> <?= htmlspecialchars($user['email']) ?></p>
<p><strong>Username:</strong> <?= htmlspecialchars($user['username']) ?></p>

<a href="booking_history.php" class="btn btn-primary mt-3">View Booking History</a>

<?php
$content = ob_get_clean();
$page_title = "Profile";
require "../src/views/layouts/public_layout.php";
