<?php
session_start();
require_once "../config/config.php";

if (!isset($_SESSION['booking_details'])) {
    die("Booking details missing. Please place your booking again.");
}

$bookingDetails = $_SESSION['booking_details'];
$email = $bookingDetails['guest_email'];
$amountGHS = $bookingDetails['amount']; // amount in cedis
$amountInKobo = $amountGHS * 100; // Paystack requires amount in kobo

$callbackUrl = 'https://' . $_SERVER['HTTP_HOST'] . '/paystack_callback.php?booking_id=' . $bookingDetails['booking_id'];
$secretKey = 'YOUR_PAYSTACK_SECRET_KEY';

$curl = curl_init();

curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.paystack.co/transaction/initialize",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => json_encode([
        'email' => $email,
        'amount' => $amountInKobo,
        'callback_url' => $callbackUrl,
    ]),
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer $secretKey",
        "Content-Type: application/json",
    ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);

curl_close($curl);

if ($err) {
    die("cURL Error: $err");
}

$res = json_decode($response);

if ($res->status) {
    header('Location: ' . $res->data->authorization_url);
    exit;
} else {
    die("Payment initialization failed: " . $res->message);
}
?>
