<?php
require_once "../config/config.php";

$booking_id = $_GET['booking_id'] ?? null;
$reference = $_GET['reference'] ?? null;

if (!$booking_id || !$reference) {
    die("Invalid payment callback data");
}

// Verify payment reference with Paystack
$curl = curl_init();

curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.paystack.co/transaction/verify/" . urlencode($reference),
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer YOUR_PAYSTACK_SECRET_KEY",
    ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);

if ($err) {
    die("Curl failed: " . $err);
}

$res = json_decode($response);

if ($res->status && $res->data->status === 'success' && $res->data->reference === $reference) {
    // Payment successful: update booking status to 'paid'
    $stmt = $pdo->prepare("UPDATE bookings SET status = 'paid' WHERE id = ?");
    $stmt->execute([$booking_id]);

    // Redirect to success page or booking details
    header("Location: booking_success.php?id=$booking_id");
    exit;
} else {
    // Payment failed or status not success
    $stmt = $pdo->prepare("UPDATE bookings SET status = 'failed' WHERE id = ?");
    $stmt->execute([$booking_id]);

    header("Location: booking_failed.php?id=$booking_id");
    exit;
}
