<?php
require_once "../config/config.php";

$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email']);
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $message = "Invalid email address.";
    } else {
        $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ? AND role = 'customer' LIMIT 1");
        $stmt->execute([$email]);
        $user = $stmt->fetch();
        if ($user) {
            // Create token (for demo, use random string; production: use secure random bytes/base64)
            $token = bin2hex(random_bytes(16));
            $expires = date('Y-m-d H:i:s', time() + 3600); // 1 hour expiry

            // Store token and expiry in password_resets table (create the table first)
            $pdo->prepare("DELETE FROM password_resets WHERE user_id = ?")->execute([$user['id']]);
            $stmt = $pdo->prepare("INSERT INTO password_resets (user_id, token, expires_at) VALUES (?, ?, ?)");
            $stmt->execute([$user['id'], $token, $expires]);

            // Send email with reset link (mocked)
            $resetLink = "http://localhost/public/password_reset.php?token=$token";
            $message = "Password reset link (mock): <a href=\"$resetLink\">$resetLink</a>";
        } else {
            $message = "No customer account found with that email.";
        }
    }
}

ob_start();
?>

<div class="container mt-5" style="max-width: 400px;">
    <h2>Password Reset</h2>
    <p>Enter your email to receive a password reset link.</p>
    <?php if ($message): ?>
        <div class="alert alert-info"><?= $message ?></div>
    <?php endif; ?>
    <form method="post" novalidate>
        <div class="mb-3">
            <label for="email" class="form-label">Email address</label>
            <input type="email" class="form-control" id="email" name="email" required />
        </div>
        <button type="submit" class="btn btn-primary w-100">Send Reset Link</button>
    </form>
</div>

<?php
$content = ob_get_clean();
$page_title = "Password Reset Request";
require "../src/views/layouts/public_layout.php";
