<?php
require_once "../config/config.php";

$message = '';
$token = $_GET['token'] ?? '';

if (!$token) {
    header('Location: password_reset_request.php');
    exit;
}

// Validate token
$stmt = $pdo->prepare("SELECT user_id FROM password_resets WHERE token = ? AND expires_at > NOW()");
$stmt->execute([$token]);
$row = $stmt->fetch();

if (!$row) {
    $message = "Invalid or expired token.";
} elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $password = $_POST['password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';

    if (!$password || !$confirm_password) {
        $message = "Please fill all fields.";
    } elseif ($password !== $confirm_password) {
        $message = "Passwords do not match.";
    } else {
        $password_hash = password_hash($password, PASSWORD_DEFAULT);
        $pdo->prepare("UPDATE users SET password = ? WHERE id = ?")->execute([$password_hash, $row['user_id']]);
        $pdo->prepare("DELETE FROM password_resets WHERE user_id = ?")->execute([$row['user_id']]);
        header('Location: login.php?reset=1');
        exit;
    }
}

ob_start();
?>

<div class="container mt-5" style="max-width: 400px;">
    <h2>Reset Password</h2>
    <?php if ($message): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>
    <?php if ($row): ?>
        <form method="post" novalidate>
            <div class="mb-3">
                <label for="password" class="form-label">New Password</label>
                <input type="password" class="form-control" id="password" name="password" required />
            </div>
            <div class="mb-3">
                <label for="confirm_password" class="form-label">Confirm New Password</label>
                <input type="password" class="form-control" id="confirm_password" name="confirm_password" required />
            </div>
            <button type="submit" class="btn btn-primary w-100">Reset Password</button>
        </form>
    <?php endif; ?>
</div>

<?php
$content = ob_get_clean();
$page_title = "Reset Password";
require "../src/views/layouts/public_layout.php";
