<?php
session_start();
require_once "../config/config.php";

$message = '';
if (isset($_GET['registered'])) {
    $message = "Registration successful. You can now login.";
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username_or_email = trim($_POST['username_or_email']);
    $password = $_POST['password'];

    $stmt = $pdo->prepare("SELECT id, username, email, password, role FROM users WHERE username = ? OR email = ?");
    $stmt->execute([$username_or_email, $username_or_email]);
    $user = $stmt->fetch();

    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['username'] = $user['username'];
        $_SESSION['role'] = $user['role'];

        // Redirect based on role
        if ($user['role'] === 'customer') {
            header("Location: profile.php");
            exit;
        } else {
            header("Location: ../admin/dashboard.php");
            exit;
        }
    } else {
        $message = "Invalid username/email or password.";
    }
}

ob_start();
?>

<div class="container mt-5" style="max-width: 400px;">
    <h2 class="mb-4">Login</h2>

    <?php if ($message): ?>
        <div class="alert alert-<?= isset($_GET['registered']) ? 'success' : 'danger' ?>">
            <?= htmlspecialchars($message) ?>
        </div>
    <?php endif; ?>

    <form method="post" novalidate>
        <div class="mb-3">
            <label for="username_or_email" class="form-label">Username or Email</label>
            <input type="text" id="username_or_email" name="username_or_email" class="form-control" required value="<?= htmlspecialchars($_POST['username_or_email'] ?? '') ?>" />
        </div>
        <div class="mb-3">
            <label for="password" class="form-label">Password</label>
            <input type="password" id="password" name="password" class="form-control" required />
        </div>
        <button type="submit" class="btn btn-primary w-100">Login</button>
        <p class="mt-3 text-center">Don't have an account? <a href="register.php">Register here</a></p>
    </form>
</div>

<?php
$content = ob_get_clean();
$page_title = "Login";
require "../src/views/layouts/public_layout.php";
