<?php
require_once "../config/config.php";
require_once "../src/models/Room.php";

$roomModel = new Room($pdo);
$featuredRooms = $roomModel->getFeaturedRooms(6);

ob_start();
?>

<style>
.hero-section {
    position: relative;
    height: 72vh;
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    text-align: center;
    overflow: hidden;
    padding: 1rem 1rem;
}

.hero-bg {
    position: absolute;
    inset: 0;
    background: url('https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRNOd5HPfxHPv4FB2xB2-r3U2DDGlyBhqlZh8CkEkh-3bHmQMHNfQFgodY86d5WaVnvOv4&usqp=CAU') no-repeat center center/cover;
    opacity: 0.85;
    filter: blur(6px);
    z-index: 1;
}

.hero-overlay {
    position: absolute;
    inset: 0;
    background: rgba(0, 0, 0, 0.7);
    z-index: 2;
}

.hero-content {
    position: relative;
    z-index: 3;
    max-width: 600px;
    width: 100%;
}

/* WhatsApp chat button styles */
#whatsapp-chat-button {
    position: fixed;
    bottom: 20px;
    right: 20px;
    background-color: #25D366;
    border-radius: 50%;
    width: 60px;
    height: 60px;
    box-shadow: 0 2px 5px rgba(0,0,0,0.3);
    z-index: 9999;
    display: flex;
    align-items: center;
    justify-content: center;
}
#whatsapp-chat-button img {
    width: 32px;
    height: 32px;
}

.room-card img {
    object-fit: cover;
    height: 185px;
    border-radius: 0.5rem;
}

.room-details i {
    color: #fcb72b;
    margin-right: 4px;
}

.carousel-inner {
    border-radius: 1rem;
}

.footer-social a {
    color: #fcb72b;
    margin-right: 12px;
    font-size: 1.22rem;
}

/* Responsive adjustments */
@media (max-width: 576px) {
    .hero-section {
        height: auto;
        padding: 2rem 1rem;
    }
    .hero-content h1 {
        font-size: 1.8rem;
        font-weight: 700;
    }
    .hero-content p.lead {
        font-size: 1.1rem;
    }
    form.row.justify-content-center.mb-3 {
        flex-direction: column;
        gap: 0.5rem;
    }
    .hero-content .col-md-3,
    .hero-content .col-md-2 {
        width: 100%;
    }
    .hero-content .btn.btn-primary {
        width: 100%;
        padding: 0.75rem 0;
        font-size: 1.1rem;
    }
}
</style>

<section class="hero-section mb-5">
    <div class="hero-bg"></div>
    <div class="hero-overlay"></div>
    <div class="hero-content container text-center">
        <h1 class="display-4 fw-bold"><?= SITE_NAME ?></h1>
        <p class="lead mb-4">Experience comfort and luxury at the heart of our hotel</p>
        <form class="row justify-content-center mb-3">
            <div class="col-md-3 mb-2">
                <input type="date" class="form-control" name="checkin" required>
            </div>
            <div class="col-md-3 mb-2">
                <input type="date" class="form-control" name="checkout" required>
            </div>
            <div class="col-md-2 mb-2">
                <select name="guests" class="form-select">
                    <option>Guests</option>
                    <option>1</option>
                    <option>2</option>
                    <option>3+</option>
                </select>
            </div>
            <div class="col-md-2 mb-2 d-grid">
                <button type="submit" class="btn btn-warning fw-bold">Find Room</button>
            </div>
        </form>
        <a href="book.php" class="btn btn-primary btn-lg rounded-pill px-4">Book Your Stay</a>
    </div>
</section>

<div class="container">
    <h2 class="fw-semibold mb-4">Featured Rooms</h2>
    <div id="featuredRoomsCarousel" class="carousel slide" data-bs-ride="carousel" data-bs-interval="3000">
        <div class="carousel-inner">
            <?php foreach (array_chunk($featuredRooms, 3) as $i => $chunk) : ?>
                <div class="carousel-item<?= $i === 0 ? ' active' : '' ?>">
                    <div class="row g-4 justify-content-center">
                        <?php foreach ($chunk as $room): ?>
                            <div class="col-md-4">
                                <div class="card room-card shadow-sm h-100">
                                    <?php
                                    $imagePath = !empty($room['image'])
                                        ? '../uploads/rooms/' . htmlspecialchars($room['image'])
                                        : 'https://via.placeholder.com/800x185?text=No+Image';
                                    ?>
                                    <img src="<?= $imagePath ?>" alt="<?= htmlspecialchars($room['room_number']) ?>" class="card-img-top" />
                                    <div class="card-body">
                                        <h5 class="card-title"><?= htmlspecialchars($room['room_number']) ?> - <?= htmlspecialchars($room['type']) ?></h5>
                                        <div class="room-details mb-2">
                                            <span><i class="bi bi-house-door"></i><?= (int)($room['beds'] ?? 0) ?> Bed(s)</span>
                                            <span><i class="bi bi-bathtub"></i><?= (int)($room['baths'] ?? 0) ?> Bath(s)</span>
                                            <span><i class="bi bi-people"></i><?= (int)($room['max_occupancy'] ?? 0) ?> Guests</span>
                                        </div>
                                        <p class="card-text small text-truncate"><?= htmlspecialchars($room['description']) ?></p>
                                        <p class="fw-bold mb-1 text-warning">GHS <?= number_format($room['price'], 2) ?> / night</p>
                                        <a href="book.php?room_id=<?= $room['id'] ?>" class="btn btn-outline-primary">Book Now</a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach ?>
                    </div>
                </div>
            <?php endforeach ?>
        </div>
        <button class="carousel-control-prev" type="button" data-bs-target="#featuredRoomsCarousel" data-bs-slide="prev">
            <span class="carousel-control-prev-icon"></span>
        </button>
        <button class="carousel-control-next" type="button" data-bs-target="#featuredRoomsCarousel" data-bs-slide="next">
            <span class="carousel-control-next-icon"></span>
        </button>
    </div>

    <div class="reviews py-5">
        <h3 class="fw-semibold text-center mb-3">Guests Love Us</h3>
        <div class="row justify-content-center">
            <div class="col-md-4">
                <div class="bg-white p-4 rounded shadow">
                    <div class="mb-2">
                        <i class="bi bi-star-fill text-warning"></i><i class="bi bi-star-fill text-warning"></i>
                        <i class="bi bi-star-fill text-warning"></i><i class="bi bi-star-fill text-warning"></i>
                        <i class="bi bi-star-half text-warning"></i>
                    </div>
                    <blockquote class="blockquote mb-2">“Amazing experience, comfy beds & superb staff.”</blockquote>
                    <figcaption class="blockquote-footer">Esi Ampofo, Accra</figcaption>
                </div>
            </div>
            <div class="col-md-4">
                <div class="bg-white p-4 rounded shadow">
                    <div class="mb-2">
                        <i class="bi bi-star-fill text-warning"></i><i class="bi bi-star-fill text-warning"></i>
                        <i class="bi bi-star-fill text-warning"></i><i class="bi bi-star-fill text-warning"></i>
                        <i class="bi bi-star-fill text-warning"></i>
                    </div>
                    <blockquote class="blockquote mb-2">“Booking online was easy and my family loved the room!”</blockquote>
                    <figcaption class="blockquote-footer">Kwame Mensah, Kumasi</figcaption>
                </div>
            </div>
        </div>
    </div>

    <div class="booking-cta py-5 text-center rounded-4 mb-4">
        <h2 class="fw-bold mb-3">Ready to Experience True Comfort?</h2>
        <a href="book.php" class="btn btn-warning btn-lg px-5 rounded-pill fw-bold me-3">Book Now</a>
    </div>
</div>

<footer class="bg-dark text-light pt-5 pb-3">
    <div class="container">
        <div class="row g-4 mb-3">
            <div class="col-md-4">
                <h5 class="mb-2">Adwenpa Hotel</h5>
                <p>Modern, client-centered hospitality for business and leisure. Luxury and convenience in the heart of Ghana.</p>
                <div class="footer-social">
                    <a href="#"><i class="bi bi-facebook"></i></a>
                    <a href="#"><i class="bi bi-instagram"></i></a>
                    <a href="#"><i class="bi bi-twitter"></i></a>
                </div>
            </div>
            <div class="col-md-4">
                <h6>Quick Links</h6>
                <ul class="list-unstyled">
                    <li><a href="index.php" class="text-warning">Home</a></li>
                    <li><a href="rooms.php" class="text-warning">Rooms</a></li>
                    <li><a href="services.php" class="text-warning">Services</a></li>
                    <li><a href="contact.php" class="text-warning">Contact</a></li>
                </ul>
            </div>
            <div class="col-md-4">
                <h6>Contact</h6>
                <p>123 Main St, Accra<br>info@adwenpahotel.com<br>+233 543 971 188</p>
            </div>
        </div>
        <div class="text-center small">&copy; <?= date('Y') ?> Adwenpa Hotel (Design by Adwenpa Consults). All Rights Reserved.</div>
    </div>
</footer>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function () {
    var myCarousel = document.querySelector('#featuredRoomsCarousel');
    new bootstrap.Carousel(myCarousel, {
        interval: 3000,
        ride: 'carousel'
    });
});
</script>

<!-- WhatsApp chat button -->
<a id="whatsapp-chat-button" href="https://wa.me/233543971188?text=Hello%20I%20have%20a%20question%20about%20booking." target="_blank" rel="noopener" aria-label="Chat with us on WhatsApp">
    <img src="https://upload.wikimedia.org/wikipedia/commons/6/6b/WhatsApp.svg" alt="WhatsApp Chat"/>
</a>

<?php
$content = ob_get_clean();
$page_title = "Home";
require "../src/views/layouts/public_layout.php";
?>
