<?php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'customer') {
    header('Location: login.php');
    exit;
}

require_once "../config/config.php";

$userId = $_SESSION['user_id'];

// Assuming bookings table now has a user_id column to link bookings to customers
$stmt = $pdo->prepare("
    SELECT b.*, r.room_number, r.type as room_type 
    FROM bookings b 
    JOIN rooms r ON b.room_id = r.id 
    WHERE b.user_id = ? 
    ORDER BY b.created_at DESC
");
$stmt->execute([$userId]);
$bookings = $stmt->fetchAll();

ob_start();
?>

<h2>Your Booking History</h2>

<?php if (empty($bookings)): ?>
    <p>You have no bookings yet.</p>
<?php else: ?>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Room</th>
                <th>Check-in</th>
                <th>Check-out</th>
                <th>Status</th>
                <th>Booked At</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($bookings as $booking): ?>
                <tr>
                    <td><?= htmlspecialchars($booking['room_number'] . " (" . $booking['room_type'] . ")") ?></td>
                    <td><?= htmlspecialchars($booking['check_in']) ?></td>
                    <td><?= htmlspecialchars($booking['check_out']) ?></td>
                    <td><?= htmlspecialchars(ucfirst($booking['status'])) ?></td>
                    <td><?= htmlspecialchars($booking['created_at']) ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>

<?php
$content = ob_get_clean();
$page_title = "Booking History";
require "../src/views/layouts/public_layout.php";
