<?php
session_start();
require_once "../includes/role_helpers.php";
requireAdmin();
require_once "../config/config.php";

$conn = getDbConnection();

// Pagination variables
$limit = 6;
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;
$offset = ($page - 1) * $limit;

// Total rows for pagination
$totalStmt = $conn->query("SELECT COUNT(*) FROM rooms");
$totalRows = $totalStmt->fetchColumn();
$totalPages = ceil($totalRows / $limit);

// Fetch rooms with paging
$sql = "SELECT * FROM rooms ORDER BY room_number LIMIT :limit OFFSET :offset";
$stmt = $conn->prepare($sql);
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();
$rooms = $stmt->fetchAll(PDO::FETCH_ASSOC);

$conn = null;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Rooms - Admin - Hotelia</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet" />
    <style>
        body { background: #f4f7fc; }
        .page-header {
            background: url('https://images.unsplash.com/photo-1506744038136-46273834b3fb?fit=crop&w=1470&q=80') center center/cover no-repeat;
            color: white;
            padding: 80px 0;
            text-align: center;
            position: relative;
        }
        .page-header::before {
            content: '';
            position: absolute;
            inset: 0;
            background: rgba(0,0,0,0.45);
            z-index: 0;
        }
        .page-header > * {
            position: relative;
            z-index: 1;
        }
        .breadcrumb a { color: #fcb72b; text-decoration: none; }
        .breadcrumb a:hover { text-decoration: underline; }

        .room-card {
            background: white;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgb(0 0 0 / 0.1);
            overflow: hidden;
            margin-bottom: 30px;
        }
        .room-image {
            position: relative;
            height: 230px;
            object-fit: cover;
            width: 100%;
        }
        .price-tag {
            position: absolute;
            top: 12px;
            right: 12px;
            background: #fcb72b;
            color: #222;
            font-weight: bold;
            padding: 6px 14px;
            border-radius: 5px;
            font-size: 0.9rem;
            z-index: 10;
        }
        .room-info {
            padding: 20px 18px;
        }
        .room-title {
            font-weight: 700;
            font-size: 1.2rem;
            margin-bottom: 8px;
        }
        .room-desc {
            font-size: 0.9rem;
            color: #555;
            height: 56px;
            overflow: hidden;
            margin-bottom: 14px;
        }
        .room-icons {
            display: flex;
            gap: 15px;
            font-size: 0.9rem;
            color: #555;
        }
        .room-icons i {
            color: #fcb72b;
            margin-right: 6px;
        }

        .filters-card {
            background: white;
            border-radius: 12px;
            padding: 20px 24px;
            box-shadow: 0 4px 20px rgb(0 0 0 / 0.1);
            margin-bottom: 30px;
        }
        .filters-card h5 {
            font-weight: 700;
            color: #fcb72b;
            margin-bottom: 18px;
        }
        .filters-card label {
            font-weight: 600;
            font-size: 0.9rem;
        }

        .pagination {
            justify-content: center;
            margin-top: 20px;
        }
    </style>
</head>
<body>

<div class="page-header">
    <div class="container">
        <h1>Rooms</h1>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb justify-content-center">
                <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page">Rooms</li>
            </ol>
        </nav>
    </div>
</div>

<div class="container my-5">
    <div class="row gx-5">
        <div class="col-lg-8">
            <div class="row">
                <?php foreach ($rooms as $room): ?>
                <div class="col-md-6">
                    <div class="room-card position-relative">
                        <img src="<?= htmlspecialchars($room['image'] ?: 'https://via.placeholder.com/500x300') ?>" alt="<?= htmlspecialchars($room['room_number']) ?>" class="room-image"/>
                        <div class="price-tag">GHS <?= number_format($room['price'], 2) ?> / Night</div>
                        <div class="room-info">
                            <div class="room-title"><?= htmlspecialchars($room['room_number']) ?></div>
                            <div class="room-desc"><?= htmlspecialchars(substr($room['description'], 0, 100)) ?>...</div>
                            <div class="room-icons">
                                <div><i class="bi bi-house-door"></i> <?= (int)$room['beds'] ?> Beds</div>
                                <div><i class="bi bi-bathtub"></i> <?= (int)$room['baths'] ?> Baths</div>
                                <div><i class="bi bi-people"></i> <?= (int)$room['adults'] ?> Adults</div>
                                <div><i class="bi bi-child"></i> <?= (int)$room['children'] ?> Children</div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
            <nav>
                <ul class="pagination">
                    <li class="page-item <?= $page <= 1 ? 'disabled' : '' ?>">
                        <a class="page-link" href="?page=<?= $page - 1 ?>" aria-label="Previous">&lsaquo;</a>
                    </li>
                    <?php for ($p = 1; $p <= $totalPages; $p++): ?>
                        <li class="page-item <?= $p == $page ? 'active' : '' ?>">
                            <a class="page-link" href="?page=<?= $p ?>"><?= $p ?></a>
                        </li>
                    <?php endfor; ?>
                    <li class="page-item <?= $page >= $totalPages ? 'disabled' : '' ?>">
                        <a class="page-link" href="?page=<?= $page + 1 ?>" aria-label="Next">&rsaquo;</a>
                    </li>
                </ul>
            </nav>
        </div>

        <div class="col-lg-4">
            <div class="filters-card">
                <h5>Filters</h5>
                <!-- Existing filter form if any here -->
                <form>
                    <div class="mb-3">
                        <label for="checkin" class="form-label">Check In / Out Date</label>
                        <input type="text" class="form-control" id="checkin" placeholder="Select dates" readonly>
                    </div>
                    <div class="row mb-3">
                        <div class="col">
                            <label for="beds" class="form-label">Beds</label>
                            <select id="beds" class="form-select">
                                <option selected>All</option>
                                <option>1</option>
                                <option>2</option>
                                <option>3+</option>
                            </select>
                        </div>
                        <div class="col">
                            <label for="baths" class="form-label">Baths</label>
                            <select id="baths" class="form-select">
                                <option selected>All</option>
                                <option>1</option>
                                <option>2</option>
                                <option>3+</option>
                            </select>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col">
                            <label for="adults" class="form-label">Adults</label>
                            <select id="adults" class="form-select">
                                <option selected>All</option>
                                <option>1</option>
                                <option>2</option>
                                <option>3+</option>
                            </select>
                        </div>
                        <div class="col">
                            <label for="children" class="form-label">Children</label>
                            <select id="children" class="form-select">
                                <option selected>All</option>
                                <option>1</option>
                                <option>2</option>
                                <option>3+</option>
                            </select>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="sort" class="form-label">Sort By</label>
                        <select id="sort" class="form-select">
                            <option>Latest Rooms</option>
                            <option>Price: Low to High</option>
                            <option>Price: High to Low</option>
                        </select>
                    </div>

                    <label class="form-label">Rent / Night (USD)</label>
                    <input type="range" class="form-range mb-3" min="20" max="700" value="100" id="priceRange">
                    <div class="mb-3">
                        <input type="text" class="form-control" placeholder="$20 - $700" readonly>
                    </div>

                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="wifiCheck">
                        <label class="form-check-label" for="wifiCheck">Free Wifi</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="parkingCheck">
                        <label class="form-check-label" for="parkingCheck">Parking</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="familyCheck">
                        <label class="form-check-label" for="familyCheck">Family Rooms</label>
                    </div>

                    <div class="mt-3">
                        <button type="submit" class="btn btn-warning w-100">Filter Rooms &rarr;</button>
                    </div>
                </form>
            </div>
        </div>

    </div>
</div>

<footer class="bg-dark text-light py-4">
    <div class="container">
        <div class="row">
            <div class="col-md-4 mb-3">
                <h5>Hotelia</h5>
                <p>Lorem ipsum is simply dummy text of the printing and typesetting industry...</p>
                <div>
                    <a href="#" class="text-warning me-2"><i class="bi bi-facebook"></i></a>
                    <a href="#" class="text-warning me-2"><i class="bi bi-google"></i></a>
                    <a href="#" class="text-warning me-2"><i class="bi bi-instagram"></i></a>
                    <a href="#" class="text-warning"><i class="bi bi-twitter"></i></a>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <h5>Quick Links</h5>
                <ul class="list-unstyled">
                    <li><a href="#" class="text-light">About Us</a></li>
                    <li><a href="#" class="text-light">FAQs</a></li>
                    <li><a href="#" class="text-light">Gallery</a></li>
                    <li><a href="#" class="text-light">Contact</a></li>
                    <li><a href="#" class="text-light">Services</a></li>
                </ul>
            </div>
            <div class="col-md-4 mb-3">
                <h5>Recent Blogs</h5>
                <ul class="list-unstyled">
                    <li><a href="#" class="text-warning">Top 10 Things to Do in Melbourne with Kids</a></li>
                    <li><a href="#" class="text-warning">Unique Travel Ideas That Don’t Involve Airports</a></li>
                    <li><a href="#" class="text-warning">The Best Beaches in the Philippines</a></li>
                </ul>
            </div>
        </div>
        <div class="text-center small">&copy; 2023 Hotelia. All rights reserved.</div>
    </div>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
