<?php
session_start();
require_once __DIR__ . '/../src/middleware/auth.php';
requireAdmin();
require_once "../config/config.php";
require_once "../src/models/Room.php";

$roomModel = new Room($pdo);
$message = '';
$rooms = $roomModel->getAllRooms();

// Handle delete room
if (isset($_POST['delete_room']) && !empty($_POST['room_id'])) {
    $room_id = (int)$_POST['room_id'];
    $stmt = $pdo->prepare("DELETE FROM rooms WHERE id = ?");
    if ($stmt->execute([$room_id])) {
        $message = "Room deleted successfully.";
        $rooms = $roomModel->getAllRooms(); // refresh list
    } else {
        $message = "Failed to delete room.";
    }
}

ob_start();
?>
<div class="container-fluid">
    <h2>Manage Rooms</h2>

    <?php if ($message): ?>
        <div class="alert alert-info"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <a href="add_room.php" class="btn btn-success mb-3">Add New Room</a>

    <?php if (empty($rooms)): ?>
        <p>No rooms found.</p>
    <?php else: ?>
        <div class="table-responsive">
        <table class="table table-bordered table-striped table-hover align-middle">
            <thead class="table-primary">
                <tr>
                    <th>Room Number</th>
                    <th>Type</th>
                    <th>Price (GHS)</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($rooms as $room): ?>
                    <tr>
                        <td><?= htmlspecialchars($room['room_number']) ?></td>
                        <td><?= htmlspecialchars($room['type']) ?></td>
                        <td><?= number_format($room['price'], 2) ?></td>
                        <td><?= htmlspecialchars(ucfirst($room['status'])) ?></td>
                        <td>
                            <a href="edit_room.php?id=<?= $room['id'] ?>" class="btn btn-sm btn-primary me-1"><i class="fa fa-edit"></i></a>
                            <form method="post" style="display:inline;" onsubmit="return confirm('Delete this room?');">
                                <input type="hidden" name="room_id" value="<?= $room['id'] ?>" />
                                <button type="submit" name="delete_room" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        </div>
    <?php endif; ?>
</div>
<?php
$content = ob_get_clean();
$page_title = "Manage Rooms";
require "../src/views/layouts/admin_layout.php";
