<?php
session_start();
require_once __DIR__ . '/../src/middleware/auth.php';
requireStaff(); // Accessible by both staff and admin
require_once "../config/config.php";

$message = '';

// Handle booking status updates
if (isset($_POST['update_status']) && isset($_POST['booking_id']) && isset($_POST['status'])) {
    $booking_id = (int)$_POST['booking_id'];
    $status = $_POST['status'];

    $stmt = $pdo->prepare("UPDATE bookings SET status = ? WHERE id = ?");
    if ($stmt->execute([$status, $booking_id])) {
        $message = "Booking status updated successfully.";
        header("Refresh:0"); // reload page to show update info
        exit;
    } else {
        $message = "Failed to update booking status.";
    }
}

// Fetch bookings with room details
$bookings = $pdo->query("
    SELECT b.*, r.room_number, r.type AS room_type
    FROM bookings b
    JOIN rooms r ON b.room_id = r.id
    ORDER BY b.created_at DESC
")->fetchAll();

ob_start();
?>

<div class="container-fluid">
    <h2>Manage Bookings</h2>

    <?php if ($message): ?>
        <div class="alert alert-info"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <?php if (empty($bookings)): ?>
        <p>No bookings found.</p>
    <?php else: ?>
        <div class="table-responsive">
        <table class="table table-striped table-bordered align-middle">
            <thead class="table-primary">
                <tr>
                    <th>Guest Name</th>
                    <th>Email</th>
                    <th>Room</th>
                    <th>Check-in</th>
                    <th>Check-out</th>
                    <th>Status</th>
                    <th>Update Status</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($bookings as $booking): ?>
                    <tr>
                        <td><?= htmlspecialchars($booking['guest_name']) ?></td>
                        <td><?= htmlspecialchars($booking['guest_email']) ?></td>
                        <td><?= htmlspecialchars($booking['room_number'] . ' (' . $booking['room_type'] . ')') ?></td>
                        <td><?= htmlspecialchars($booking['check_in']) ?></td>
                        <td><?= htmlspecialchars($booking['check_out']) ?></td>
                        <td>
                            <?php
                                $status_badge = [
                                    'pending' => 'badge bg-warning text-dark',
                                    'confirmed' => 'badge bg-success',
                                    'cancelled' => 'badge bg-danger'
                                ];
                            ?>
                            <span class="<?= $status_badge[$booking['status']] ?? 'badge bg-secondary' ?>">
                                <?= ucfirst($booking['status']) ?>
                            </span>
                        </td>
                        <td>
                            <form method="post" class="d-flex gap-2 align-items-center">
                                <input type="hidden" name="booking_id" value="<?= $booking['id'] ?>" />
                                <select name="status" class="form-select form-select-sm" required>
                                    <option value="pending" <?= $booking['status'] === 'pending' ? 'selected' : '' ?>>Pending</option>
                                    <option value="confirmed" <?= $booking['status'] === 'confirmed' ? 'selected' : '' ?>>Confirmed</option>
                                    <option value="cancelled" <?= $booking['status'] === 'cancelled' ? 'selected' : '' ?>>Cancelled</option>
                                </select>
                                <button type="submit" name="update_status" class="btn btn-sm btn-primary" title="Update Status">
                                    <i class="fa fa-check"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        </div>
    <?php endif; ?>
</div>

<?php
$content = ob_get_clean();
$page_title = "Manage Bookings";
require "../src/views/layouts/admin_layout.php";
