<?php
session_start();
require_once "../config/config.php";

header('Content-Type: application/json');

$mark_read = $_POST['view'] ?? '';

if ($mark_read === 'yes') {
    $pdo->query("UPDATE admin_notifications SET is_read = TRUE WHERE is_read = FALSE");
}

$stmt = $pdo->query("SELECT * FROM admin_notifications ORDER BY created_at DESC LIMIT 5");
$notifications = $stmt->fetchAll();

$countStmt = $pdo->query("SELECT COUNT(*) FROM admin_notifications WHERE is_read = FALSE");
$unreadCount = $countStmt->fetchColumn();

$output = '';
if (count($notifications) === 0) {
    $output .= '<li><a class="dropdown-item" href="#">No notifications</a></li>';
} else {
    foreach ($notifications as $notif) {
        $boldClass = $notif['is_read'] ? '' : 'fw-bold';
        $output .= '<li><a class="dropdown-item '.$boldClass.'" href="#">' .
            htmlspecialchars($notif['title']) . '<br><small class="text-muted">' .
            $notif['created_at'] . '</small></a></li>';
    }
}

echo json_encode([
    'notification' => $output,
    'unseen_count' => $unreadCount
]);
