<?php
session_start();
require_once __DIR__ . '/../src/middleware/auth.php';
requireAdmin();
require_once "../config/config.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $booking_id = (int)($_POST['booking_id'] ?? 0);
    $action = $_POST['action'] ?? '';

    if ($booking_id > 0 && in_array($action, ['confirm', 'cancel'])) {
        $newStatus = $action === 'confirm' ? 'confirmed' : 'cancelled';
        $stmt = $pdo->prepare("UPDATE bookings SET status = ? WHERE id = ?");
        $stmt->execute([$newStatus, $booking_id]);
    }
}

header("Location: admin/dashboard.php");
exit;
